/*
 * QrfeGen2Tag.h
 *
 *  Created on: 30.07.2009
 *      Author: stefan.detter
 */

#ifndef QRFEGEN2TAG_H_
#define QRFEGEN2TAG_H_

#include "QrfeTagInterface.h"
#include "../QrfeGen2ManipulatorInterface.h"
#include "../epc/EPC_Defines.h"

class QrfeGen2Tag : public QrfeTagInterface
{
	Q_OBJECT

public:
	typedef enum{
		MEM_RES 	= 0x00,
		MEM_EPC 	= 0x01,
		MEM_TID 	= 0x02,
		MEM_USER 	= 0x03,
	} MEMORY_BANK;

	typedef enum{
		UNLOCK 				= 0x00,
		LOCK 				= 0x01,
		PERMALOCK 			= 0x02,
		LOCK_AND_PERMALOCK 	= 0x03
	} LOCK_MODE;

	typedef enum{
		KILL_PASSWORD 	= 0x00,
		ACCESS_PASSWORD = 0x01,
		EPC 			= 0x02,
		TID 			= 0x03,
		USER 			= 0x04,
	} LOCK_MEMORY_SPACE;


	QrfeGen2Tag(QString tagId, QrfeGen2ManipulatorInterface* reader, QObject* parent = 0);
	virtual ~QrfeGen2Tag();

	virtual QrfeGlobal::TMIResult readInformations();

	virtual QrfeGen2ManipulatorInterface*	tagManipulatorInterface();


	QrfeGlobal::TMIResult setTagId ( QString tagId_After, QByteArray passwd );
	QrfeGlobal::TMIResult setAccessPassword ( QByteArray currentPassw, QByteArray newPassw );
	QrfeGlobal::TMIResult setKillPassword ( QByteArray currentPassw, QByteArray newPassw );

	QrfeGlobal::TMIResult readFromTag ( MEMORY_BANK mem_bank, ushort address, QByteArray passwd, uchar count, QByteArray &data );
    QrfeGlobal::TMIResult writeToTag (MEMORY_BANK mem_bank, ushort address, QByteArray passwd, QByteArray data , bool retry = true);

	QrfeGlobal::TMIResult lockTag ( LOCK_MODE mode, LOCK_MEMORY_SPACE memory, QByteArray passwd );
	QrfeGlobal::TMIResult killTag ( QByteArray killPassword );


	QrfeGen2ManipulatorInterface* 	gen2TagManipulatorInterface();

protected:
	QrfeGen2ManipulatorInterface*	m_gen2reader;
};

#endif /* QRFEGEN2TAG_H_ */
